
class Workflow:
    def __init__(
        self,
        name: str,
        llm_config,
        dataset: DatasetType,
    ) -> None:
        self.name = name
        self.dataset = dataset
        self.llm = create_llm_instance(llm_config)
        self.llm.cost_manager = CostManager()
        self.custom = operator.Custom(self.llm)

    async def __call__(self, problem: str):
        """
        Implementation of the workflow
        """
        outline = await self.custom(input=problem, instruction=prompt_custom.OUTLINE_PROMPT)
        solution = await self.custom(input=problem + f"\nOutline: {outline['response']}", instruction=prompt_custom.PROPOSAL_PROMPT)
        return solution['response'], self.llm.cost_manager.total_cost
